#version 330 core

// Input data
in vec2 texCoord;
in vec3 LightDirection1;
in vec3 LightDirection2;
in vec3 LightDirection3;
in vec3 LightDirection4;
in vec3 LightDirection5;
in vec3 LightDirection6;
in vec3 LightDirection7;
in vec3 LightDirection8;
in vec3 ViewDirection;
in vec3 Normal;

// Output data
out vec4 color;

// Values that stay constant for the whole draw.
uniform vec4 Diffuse;
uniform vec4 Ambient;
uniform vec4 Specular;
uniform vec4 LightColor1;
uniform vec4 LightColor2;
uniform vec4 LightColor3;
uniform vec4 LightColor4;
uniform vec4 LightColor5;
uniform vec4 LightColor6;
uniform vec4 LightColor7;
uniform vec4 LightColor8;
uniform float SpecularPower;
uniform float LightIntensity1;
uniform float LightIntensity2;
uniform float LightIntensity3;
uniform float LightIntensity4;
uniform float LightIntensity5;
uniform float LightIntensity6;
uniform float LightIntensity7;
uniform float LightIntensity8;
uniform float Time;
uniform float Sync;
uniform sampler2D diffuseMap;
uniform sampler2D bumpMap;

void main(void)
{
	vec3 nLightDirection1 = normalize(LightDirection1);
	vec3 nLightDirection2 = normalize(LightDirection2);
	vec3 nLightDirection3 = normalize(LightDirection3);
	vec3 nLightDirection4 = normalize(LightDirection4);
	vec3 nLightDirection5 = normalize(LightDirection5);
	vec3 nLightDirection6 = normalize(LightDirection6);
	vec3 nLightDirection7 = normalize(LightDirection7);
	vec3 nLightDirection8 = normalize(LightDirection8);
	vec3 nNormal = normalize( (texture(bumpMap, texCoord).xyz * 2.0) - 1.0);
      
	float NDotL1 = dot( nNormal, nLightDirection1 );
	float NDotL2 = dot( nNormal, nLightDirection2 );
	float NDotL3 = dot( nNormal, nLightDirection3 );
	float NDotL4 = dot( nNormal, nLightDirection4 );
	float NDotL5 = dot( nNormal, nLightDirection5 );
	float NDotL6 = dot( nNormal, nLightDirection6 );
	float NDotL7 = dot( nNormal, nLightDirection7 );
	float NDotL8 = dot( nNormal, nLightDirection8 );

	vec3 Reflection = normalize(((2.0 * nNormal) * NDotL1 * NDotL2 *NDotL3) - nLightDirection1 - nLightDirection2 - nLightDirection3);
	vec3 nViewDirection = normalize(ViewDirection);
	float RDotV = max(0.0, dot(Reflection, nViewDirection));
   
	vec4 diffuseColor = texture(diffuseMap, texCoord);
	vec4 DiffuseColor = diffuseColor * Diffuse * NDotL1 * NDotL2 * NDotL3 * LightIntensity1 * LightColor1 * LightIntensity2 * LightColor2 * LightIntensity3 * LightColor3;
	vec4 AmbientColor = Ambient * diffuseColor;
	vec4 SpecularColor = Specular * pow(RDotV, SpecularPower);
   
	color = DiffuseColor + AmbientColor + SpecularColor;
	//color = vec4(0.0, 0.0, 0.8, 1.0);
}